var topic = "<!DOCTYPE html>\r\n\n<!-- saved from url=(0024)http://docs.autodesk.com -->\r\n<html>\n   <head>\n      <meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">\n      <meta name=\"product\" content=\"RSTR\">\n      <meta name=\"release\" content=\"2019\">\n      <meta name=\"book\" content=\"Installation\">\n      <meta name=\"created\" content=\"2018-01-15\">\n      <meta name=\"topicid\" content=\"GUID-5D66A4C3-03CB-423D-933D-632D5E53C97E\">\n      <meta name=\"description\" content=\"Package files include licenses for multiple releases of a product.\">\n      <meta name=\"indexterm\" content=\"single license model\">\n      <meta name=\"indexterm\" content=\"distributed license model\">\n      <meta name=\"indexterm\" content=\"redundant license model\">\n      <meta name=\"topic-type\" content=\"topic\">\n      <meta name=\"audience\" content=\"administrator\">\n      <meta name=\"experiencelevel\" content=\"general\">\n      <meta name=\"topic-subtype\" content=\"installing\">\n      <meta name=\"keywords\" content=\"combined network license, multi-product network license\">\n      <meta name=\"keyword\" content=\"combined network license\">\n      <meta name=\"keyword\" content=\"multi-product network license\">\n      <title>About Package License Files</title><script language=\"javascript\">var index = \'index.html\';</script></head>\n   <body height=\"100%\">\n      <div class=\"body_content\" id=\"body-content\" dir=\"ltr\"><a name=\"GUID-5D66A4C3-03CB-423D-933D-632D5E53C97E\"></a><div class=\"head\">\n            <h1>About Package License Files</h1>\n         </div>\n         <p class=\"blurb\"> Package files include licenses for multiple releases of a product. \n            \n         </p>\n         <p><a name=\"WS1A9193826455F5FF-3859B43C1209703A838-4722\"></a> If you have a multi-user or maintenance plan for multiple versions of an Autodesk\n            product, you can obtain a package file. Package files contain a set of licenses for\n            four releases of the same product, such as AutoCAD 2013-2016. Running an instance\n            of any one of the releases uses one license in the package. \n            	 \n         </p><a name=\"WS1A9193826455F5FF-3859B43C1209703A838-471F\"></a><ul>\n            <li>Package license files authorize the use of the current version and limited previous\n               versions of the same product. \n               		\n            </li>\n            <li>They can be combined with license files for different products. \n               		\n            </li>\n            <li>They can\'t be combined with non-package license files for product versions in the\n               package. For example, you can\'t combine an AutoCAD 2016 package license file with\n               a regular license file for AutoCAD 2016, 2015, 2014, or 2013. \n               		\n            </li>\n            <li>They rely on both the PACKAGE and INCREMENT sections in the license file. When you\n               combine license files, be sure to include both these sections. \n               		\n            </li>\n            <li>They support license borrowing, license cascading, and options files. \n               		\n            </li>\n            <li>They assume that a new license file supersedes an older one. \n               		\n            </li>\n         </ul>\n         <p><a name=\"GUID-9D21989C-6BED-410E-BA5D-8F7AF79E51FA\"></a><em class=\"strong\">Example of a package license file for a single or distributed license server model:</em> \n         </p>\n         <div class=\"codeBlock\"><pre>SERVER SIN3NYDYZ1 ECF4BB2BB7FB\nUSE_SERVER\nVENDOR adskflex port=2080\nPACKAGE 64300ACD_T_F adskflex 1.000 COMPONENTS=\"86445ACD_2016_0F \\\n	86295ACD_2015_0F 86063ACD_2014_0F 85871ACD_2013_0F\" \\\n	OPTIONS=SUITE SUPERSEDE=64300ACD_T_F ISSUED=17-Dec-2015 \\\n	SIGN=\"1F73 1BAA DF94 D6A3 FD09 9D93 1E78 03E6 0E26 6424 54A2 \\\n	5037 3D67 E87B 97E2 004B 0D93 539C FCDD 03C0 D138 46FA 5BAB \\\n	E44F CCD2 9A96 3DB7 DDC0 3365 8048\" SIGN2=\"1F76 C3C6 BFE6 ED0F \\\n	FA58 CE28 F422 FECB 1776 2221 11A3 7BA2 998C BB16 955D 0696 \\\n	B567 2C5E 707C C6B7 9624 6ED6 3C20 1F56 35DB 749E 7A55 9221 \\\n	E2E1 A231\"\nINCREMENT 64300ACD_T_F adskflex 1.000 15-feb-2017 5 \\\n	VENDOR_STRING=commercial:extendable SUPERSEDE=64300ACD_T_F \\\n	DUP_GROUP=UH SUITE_DUP_GROUP=UHV ISSUED=17-Dec-2015 \\\n	BORROW=4320 SN=XXX-XXXXXXXX SIGN=\"1234 3F57 2AAC 2C12 9914 \\\n	481F DA32 4622 FB61 EDE8 C9AA 9DCB EC06 BBE3 9548 1AF3 C41A \\\n	B91A 0F12 8F9B EF45 A43E E600 A2AF D729 48A7 540B 6324 E1E6 \\\n	B87C\" SIGN2=\"0C52 1E0C 8E64 233D DFB0 76B5 9DDD 7756 1284 9003 \\\n	FAEF F8F4 D95C 3442 8E1B 08AD 8205 D6E9 ADAD 3253 55C2 B65A \\\n	2861 ECC3 6F00 58A1 6E9A B54D 99AE 51B5\"</pre></div>\n         <p> </p>\n         <p><a name=\"GUID-E0EB8BA8-35CA-47B8-BC3A-F0EFBDBA761B\"></a><em class=\"strong\">Example of a package license file for a redundant license server model: \n               		</em> \n         </p>\n         <div class=\"codeBlock\"><pre>SERVER ServerName1 11223344AABB 27005\nSERVER ServerName2 11223355AACC 27005\nSERVER ServerName3 BBAADD112233 27005\nUSE_SERVER\nVENDOR adskflex port=2080\nPACKAGE 64300ACD_T_F adskflex 1.000 COMPONENTS=\"86445ACD_2016_0F \\\n	86295ACD_2015_0F 86063ACD_2014_0F 85871ACD_2013_0F\" \\\n	OPTIONS=SUITE SUPERSEDE=64300ACD_T_F ISSUED=11-Jan-2016 \\\n	SIGN=\"0A04 50D0 1AD0 13BE CD11 19EF 7BF3 8CEE AE68 16D1 7D95 \\\n	7373 1273 5B9B 9946 0511 0248 11AF B0DC 0426 6C95 5082 9A31 \\\n	9A3B 25B2 2DBC 9B80 CDF7 77CB FDCA\" SIGN2=\"1247 758F E999 0CF2 \\\n	7ADE AB32 FF51 1B57 B20C 85D1 AA4E AA89 48C1 0C8D C696 0950 \\\n	0C64 B075 2DE9 96C6 B2B8 79F4 5DF8 3297 316F DCE9 1B02 AC83 \\\n	802E 62E4\"\nINCREMENT 64300ACD_T_F adskflex 1.000 11-jan-2017 10 \\\n	VENDOR_STRING=commercial:extendable SUPERSEDE=64300ACD_T_F \\\n	DUP_GROUP=UH SUITE_DUP_GROUP=UHV ISSUED=11-Jan-2016 \\\n	BORROW=4320 SN=XXX-XXXXXXXX SIGN=\"1F26 73A5 863C 79A9 EA55 \\\n	37BF 4528 FBDB C98D 5611 4CF0 88E8 B4E8 BDDC 5A99 05D4 3A5C \\\n	0B65 6B36 0809 B3D0 CB41 9171 199F E311 2A83 D122 E2EC 4E2E \\\n	F6B9\" SIGN2=\"04F3 2580 C6D7 6B7F 9AD0 E9B5 9F80 77EB EAEA B06E \\\n	FE91 F93D FF4A 1C43 58F1 1667 8043 4A7D B560 7071 A6D1 5408 \\\n	FE5E C83B F9B5 6B60 9E5A 41C8 B471 20A7\"</pre></div>\n         <p><a name=\"GUID-74FD7D0B-D5FF-47D0-BAFB-76EB6D70094F\"></a>The distinguishing feature of this type of license file is the series of three SERVER\n            lines at the beginning. A copy of this license file is placed on each of the specified\n            servers. \n            	 \n         </p>\n         <p> </p>\n         <p><a name=\"GUID-D076340B-4804-4F64-9EB1-4B7F61F5CF5A\"></a><em class=\"strong\">Example of a combined package license file for AutoCAD 2013-2016 and Inventor 2013-2016:\n               \n               		</em> \n         </p>\n         <div class=\"codeBlock\"><pre>SERVER ServerName1 11223344AABB\nUSE_SERVER\nVENDOR adskflex port=2080\nPACKAGE 64300ACD_T_F adskflex 1.000 COMPONENTS=\"86445ACD_2016_0F \\\n	86295ACD_2015_0F 86063ACD_2014_0F 85871ACD_2013_0F\" \\\n	OPTIONS=SUITE SUPERSEDE=64300ACD_T_F ISSUED=10-Jan-2016 \\\n	SIGN=\"0A04 50D0 1AD0 13BE CD11 19EF 7BF3 8CEE AE68 16D1 7D95 \\\n	7373 1273 5B9B 9946 0511 0248 11AF B0DC 0426 6C95 5082 9A31 \\\n	9A3B 25B2 2DBC 9B80 CDF7 77CB FDCA\" SIGN2=\"1247 758F E999 0CF2 \\\n	7ADE AB32 FF51 1B57 B20C 81D1 AA4E AA89 48C1 0C8D C696 0950 \\\n	0C64 B075 2DE9 96C6 B2B8 79F4 5DF8 3297 316F DCE9 1B02 AC83 \\\n	802E 62E5\"\nINCREMENT 64300ACD_T_F adskflex 1.000 10-jan-2017 10 \\\n	VENDOR_STRING=commercial:extendable SUPERSEDE=64300ACD_T_F \\\n	DUP_GROUP=UH SUITE_DUP_GROUP=UHV ISSUED=10-Jan-2016 \\\n	BORROW=4320 SN=XXX-XXXXXXXX SIGN=\"128A A06A 52D4 FF0D A265 \\\n	CE93 90F0 DDDB 9C19 039D 28DB 73CF 5CA9 7486 313B 160D C865 \\\n	DF0B A0AA E2FA 428E F180 8C31 562D 184E BC6E 516B 53E8 8980 \\\n	4EF8\" SIGN2=\"149A 87CF CB50 1AF2 C4BC 41BC 4F46 683A 93FC EB96 \\\n	E4AA DF34 425D C437 BF31 0317 2A16 3477 A58D FD55 7D23 E312 \\\n	C984 CBA3 E5D3 9589 FD83 57BB F8D0 B7D6\"\nPACKAGE 85578INVNTOR_T_F adskflex 1.000 \\\n	COMPONENTS=\"86492INVNTOR_2016_0F 86314INVNTOR_2015_0F \\\n	86159INVNTOR_2014_0F 85998INVNTOR_2013_0F\" OPTIONS=SUITE \\\n	SUPERSEDE=85578INVNTOR_T_F ISSUED=11-Jan-2016 SIGN=\"0B61 EF4B \\\n	5701 1644 22B8 7489 7FFC 8C2D 7BDA 4275 C7AB A062 6E4B 0EC1 \\\n	40AB 0F99 DB33 820A B746 04CB BFD7 97D6 533D 8634 CE7C 6ED6 \\\n	54C4 391B B6A8 51E0\" SIGN2=\"1E09 428A 0497 B08E A52A 5343 0E87 \\\n	9F2C 940E 1116 A208 3FCE DBAA A14D 8232 1140 83DE 897B 98DA \\\n	C078 6355 6D56 E611 6B6C 336C BAD2 F5C4 3CCD 8C7E AEBF\"\nINCREMENT 85578INVNTOR_T_F adskflex 1.000 11-jan-2017 10 \\\n	VENDOR_STRING=commercial:extendable SUPERSEDE=85578INVNTOR_T_F \\\n	DUP_GROUP=UH SUITE_DUP_GROUP=UHV ISSUED=11-Jan-2016 \\\n	BORROW=4320 SN=XXX-XXXXXXXX SIGN=\"0694 A30D 80BD FF2B 13F3 \\\n	9664 DD62 9165 68EC B85A 4E83 5063 6020 3602 4799 1143 8547 \\\n	2464 D06C 9EE3 299B ED18 E0D0 8CD7 012A 2A69 2875 7493 D4B5 \\\n	66E9\" SIGN2=\"15CD 5872 2E98 5130 C917 BAFD CB9F 23ED 7049 0C31 \\\n	B3BA 981D 2268 3542 D62B 0C36 10B7 C924 D5BF 94D2 01CE 8744 \\\n	712B 812D B653 D80F F0FF 0068 C575 8789\"</pre></div>\n         <div class=\"related-topics\"><span class=\"noindex\">\n               <div class=\"related-information\">\n                  <h4 class=\"related\">Related Information</h4>\n                  <ul>\n                     <li class=\"topiclist-litem\"><a href=\"license_workflow_license_options.htm\">About License Management Options and Tools</a></li>\n                  </ul>\n               </div></span></div>\n         <div class=\"footer-block\"><a href=\"..\" class=\"comments-anchor\" target=\"_blank\"><span class=\"comments-link\">Please send us your comment about this page</span></a></div><br><p class=\"footer-license-block\"><a rel=\"license\" href=\"http://creativecommons.org/licenses/by-nc-sa/3.0/\" target=\"_blank\"><img alt=\"Creative Commons License\" style=\"border-width: 0;\" src=\"../images/ccLink.png\"></a>&nbsp;<em>Except where otherwise noted, this work is licensed under a <a rel=\"license\" href=\"http://creativecommons.org/licenses/by-nc-sa/3.0/\" target=\"_blank\">Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License</a>. Please see the <a href=\"http://autodesk.com/creativecommons\" target=\"_blank\">Autodesk Creative Commons FAQ</a> for more information.</em></p><br></div>\n   </body>\n</html>";
// SIG // Begin signature block
// SIG // MIIbQQYJKoZIhvcNAQcCoIIbMjCCGy4CAQExDzANBglg
// SIG // hkgBZQMEAgEFADB3BgorBgEEAYI3AgEEoGkwZzAyBgor
// SIG // BgEEAYI3AgEeMCQCAQEEEBDgyQbOONQRoqMAEEvTUJAC
// SIG // AQACAQACAQACAQACAQAwMTANBglghkgBZQMEAgEFAAQg
// SIG // VDljUawj5yP9t/it4Vh0lFq57x40vUgSXVD/XUdHpJqg
// SIG // ggoWMIIExzCCA6+gAwIBAgIQLlHY9Ndmb2zQll6+Kgx7
// SIG // KjANBgkqhkiG9w0BAQsFADCBhDELMAkGA1UEBhMCVVMx
// SIG // HTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8w
// SIG // HQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3JrMTUw
// SIG // MwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
// SIG // b2RlIFNpZ25pbmcgQ0EgLSBHMjAeFw0xNzA2MjAwMDAw
// SIG // MDBaFw0xODA2MjAyMzU5NTlaMHgxCzAJBgNVBAYTAlVT
// SIG // MRMwEQYDVQQIDApDYWxpZm9ybmlhMRMwEQYDVQQHDApT
// SIG // YW4gUmFmYWVsMRcwFQYDVQQKDA5BdXRvZGVzaywgSW5j
// SIG // LjENMAsGA1UECwwESVNSQzEXMBUGA1UEAwwOQXV0b2Rl
// SIG // c2ssIEluYy4wggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAw
// SIG // ggEKAoIBAQCWOkLrhgKJc4cdkvAOeJKDALJyy0m/NoWe
// SIG // xtX9gEthpW13RF7h/lYXoRqnSOrt6xk1O2U+UiwINp8p
// SIG // 0BiM2batbfwxKNzTYzV3QtR5kuK+3DJ28S/k/lpPeccO
// SIG // 8cPnR2XepZ7CYHDn2bS2dm8OfMvpUQjZEpVh+Ocv3tkB
// SIG // ZKhhH6TEkbL0OFbJM12uJtNyisfpY/swEiYUBpKed0Zj
// SIG // cCtrQ5BIDqhZA/6kJbxTxTalbvbwJFEDPCrqtc1KV7NZ
// SIG // fiMkkdme/ScdDcGCdYpqR5xt54egqg6/xJOyrDtGW0EV
// SIG // b6bU68ZFMeqfKHCZyXE42/mBac1i+rWjeGZ4zwz8LliZ
// SIG // AgMBAAGjggE+MIIBOjAJBgNVHRMEAjAAMA4GA1UdDwEB
// SIG // /wQEAwIHgDATBgNVHSUEDDAKBggrBgEFBQcDAzBhBgNV
// SIG // HSAEWjBYMFYGBmeBDAEEATBMMCMGCCsGAQUFBwIBFhdo
// SIG // dHRwczovL2Quc3ltY2IuY29tL2NwczAlBggrBgEFBQcC
// SIG // AjAZDBdodHRwczovL2Quc3ltY2IuY29tL3JwYTAfBgNV
// SIG // HSMEGDAWgBTUwAYiSes5S92T4lyhuEd2CXIDWDArBgNV
// SIG // HR8EJDAiMCCgHqAchhpodHRwOi8vcmIuc3ltY2IuY29t
// SIG // L3JiLmNybDBXBggrBgEFBQcBAQRLMEkwHwYIKwYBBQUH
// SIG // MAGGE2h0dHA6Ly9yYi5zeW1jZC5jb20wJgYIKwYBBQUH
// SIG // MAKGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3J0MA0G
// SIG // CSqGSIb3DQEBCwUAA4IBAQBnP911vx5AalekBbG3iscF
// SIG // RO88rBim60QD86JT5VendZmZKCt+d+vQjRPNdEQ9wjPS
// SIG // V3R2n+7eIVrf0oaN90hca9KAuuovkyRMU/UVVod3vfUv
// SIG // 8XvtNSJT0g3/Yei7WlBIE74QGz7brUWQYY74/2H5svn1
// SIG // 6WmXUd/HoP767an7iMORFsIIHSdESj9RVSXzWLa1N7oR
// SIG // UwRsBM8wUYjfUmEVUwFXMc/eMz55Wc+yYzS+IOsCN4l1
// SIG // TT5A16vX3O4XKYJo1q5dMs8+Q7BSdS8pKyExKCq0/SYu
// SIG // JUJWOHE1SbXmCPRyAWm1nPOtWMI13QzjWO5cAVW2cNKA
// SIG // 6fCl4nFctmEZMIIFRzCCBC+gAwIBAgIQfBs1NUrn23Tn
// SIG // QV8RacprqDANBgkqhkiG9w0BAQsFADCBvTELMAkGA1UE
// SIG // BhMCVVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJbmMuMR8w
// SIG // HQYDVQQLExZWZXJpU2lnbiBUcnVzdCBOZXR3b3JrMTow
// SIG // OAYDVQQLEzEoYykgMjAwOCBWZXJpU2lnbiwgSW5jLiAt
// SIG // IEZvciBhdXRob3JpemVkIHVzZSBvbmx5MTgwNgYDVQQD
// SIG // Ey9WZXJpU2lnbiBVbml2ZXJzYWwgUm9vdCBDZXJ0aWZp
// SIG // Y2F0aW9uIEF1dGhvcml0eTAeFw0xNDA3MjIwMDAwMDBa
// SIG // Fw0yNDA3MjEyMzU5NTlaMIGEMQswCQYDVQQGEwJVUzEd
// SIG // MBsGA1UEChMUU3ltYW50ZWMgQ29ycG9yYXRpb24xHzAd
// SIG // BgNVBAsTFlN5bWFudGVjIFRydXN0IE5ldHdvcmsxNTAz
// SIG // BgNVBAMTLFN5bWFudGVjIENsYXNzIDMgU0hBMjU2IENv
// SIG // ZGUgU2lnbmluZyBDQSAtIEcyMIIBIjANBgkqhkiG9w0B
// SIG // AQEFAAOCAQ8AMIIBCgKCAQEA15VD1NzfZ645+1KktiYx
// SIG // BHDpt45bKro3aTWVj7vAMOeG2HO73+vRdj+KVo7rLUvw
// SIG // VxhOsY2lM9MLdSPVankn3aPT9w6HZbXerRzx9TW0IlGv
// SIG // IqHBXUuQf8BZTqudeakC1x5JsTtNh/7CeKu/71KunK8I
// SIG // 2TnlmlE+aV8wEE5xY2xY4fAgMxsPdL5byxLh24zEgJRy
// SIG // u/ZFmp7BJQv7oxye2KYJcHHswEdMj33D3hnOPu4Eco4X
// SIG // 0//wsgUyGUzTsByf/qV4IEJwQbAmjG8AyDoAEUF6QbCn
// SIG // ipEEoJl49He082Aq5mxQBLcUYP8NUfSoi4T+IdpcXn31
// SIG // KXlPsER0b21y/wIDAQABo4IBeDCCAXQwLgYIKwYBBQUH
// SIG // AQEEIjAgMB4GCCsGAQUFBzABhhJodHRwOi8vcy5zeW1j
// SIG // ZC5jb20wEgYDVR0TAQH/BAgwBgEB/wIBADBmBgNVHSAE
// SIG // XzBdMFsGC2CGSAGG+EUBBxcDMEwwIwYIKwYBBQUHAgEW
// SIG // F2h0dHBzOi8vZC5zeW1jYi5jb20vY3BzMCUGCCsGAQUF
// SIG // BwICMBkaF2h0dHBzOi8vZC5zeW1jYi5jb20vcnBhMDYG
// SIG // A1UdHwQvMC0wK6ApoCeGJWh0dHA6Ly9zLnN5bWNiLmNv
// SIG // bS91bml2ZXJzYWwtcm9vdC5jcmwwEwYDVR0lBAwwCgYI
// SIG // KwYBBQUHAwMwDgYDVR0PAQH/BAQDAgEGMCkGA1UdEQQi
// SIG // MCCkHjAcMRowGAYDVQQDExFTeW1hbnRlY1BLSS0xLTcy
// SIG // NDAdBgNVHQ4EFgQU1MAGIknrOUvdk+JcobhHdglyA1gw
// SIG // HwYDVR0jBBgwFoAUtnf6aUhHn1MS1cLqBzJ2B9GXBxkw
// SIG // DQYJKoZIhvcNAQELBQADggEBAH/ryqfqi3ZC6z6OIFQw
// SIG // 47e53PpIPhbHD0WVEM0nhqNm8wLtcfiqwlWXkXCD+VJ+
// SIG // Umk8yfHglEaAGLuh1KRWpvMdAJHVhvNIh+DLxDRoIF60
// SIG // y/kF7ZyvcFMnueg+flGgaXGL3FHtgDolMp9Er25DKNMh
// SIG // dbuX2IuLjP6pBEYEhfcVnEsRjcQsF/7Vbn+a4laS8Zaz
// SIG // rS359N/aiZnOsjhEwPdHe8olufoqaDObUHLeqJ/UzSwL
// SIG // NL2LMHhA4I2OJxuQbxq+CBWBXesv4lHnUR7JeCnnHmW/
// SIG // OO8BSgEJJA4WxBR5wUE3NNA9kVKUneFo7wjw4mmcZ26Q
// SIG // CxqTcdQmAsPAWiMxghCDMIIQfwIBATCBmTCBhDELMAkG
// SIG // A1UEBhMCVVMxHTAbBgNVBAoTFFN5bWFudGVjIENvcnBv
// SIG // cmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBUcnVzdCBO
// SIG // ZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAz
// SIG // IFNIQTI1NiBDb2RlIFNpZ25pbmcgQ0EgLSBHMgIQLlHY
// SIG // 9Ndmb2zQll6+Kgx7KjANBglghkgBZQMEAgEFAKB8MBAG
// SIG // CisGAQQBgjcCAQwxAjAAMBkGCSqGSIb3DQEJAzEMBgor
// SIG // BgEEAYI3AgEEMBwGCisGAQQBgjcCAQsxDjAMBgorBgEE
// SIG // AYI3AgEVMC8GCSqGSIb3DQEJBDEiBCBICqVrs3nx28VU
// SIG // 4K0blD9dcxRPL2Z2LCccEAVZNUfMyTANBgkqhkiG9w0B
// SIG // AQEFAASCAQBT/0ZZPtvPr255aUviPun+mlhoHQkLQif6
// SIG // xqMV1ESWjka3gDF/9gOwjm4Uz0xB7mmmG35/VRRQy8WC
// SIG // jtf0B8JD79ed0KaP+m6SVdXehNRtm1PgHsl354J1zQCs
// SIG // swVm01JdridfQJqz6ie1Chj50/ajPqMLD9ii8iGjiEEp
// SIG // HWLmNF2alGU25/QBF3o6ObL70Xqj9EVyTyjC7FwqzX+2
// SIG // IrwGXJCf/xYtJmDTxdGY841dYG7E7lJGCCCXw4CpXmcm
// SIG // rIJ0XHGJKkP9H/qcBJHhhEOiR5sGJIfFS0qhES3JB4NZ
// SIG // gMeu1KaWcgCivZ7F31buMbN6cHbns3c2ihgN6uHylmL4
// SIG // oYIOPDCCDjgGCisGAQQBgjcDAwExgg4oMIIOJAYJKoZI
// SIG // hvcNAQcCoIIOFTCCDhECAQMxDTALBglghkgBZQMEAgEw
// SIG // ggEOBgsqhkiG9w0BCRABBKCB/gSB+zCB+AIBAQYLYIZI
// SIG // AYb4RQEHFwMwMTANBglghkgBZQMEAgEFAAQgIl+gaisH
// SIG // Zbx0xbMLGmPGEMTjLnIYAP34WtIRFxXg95cCFGEUfnKk
// SIG // 2r+2IMMDmI4uRJlWoOrAGA8yMDE4MDExNjAzMDQwOVow
// SIG // AwIBHqCBhqSBgzCBgDELMAkGA1UEBhMCVVMxHTAbBgNV
// SIG // BAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQL
// SIG // ExZTeW1hbnRlYyBUcnVzdCBOZXR3b3JrMTEwLwYDVQQD
// SIG // EyhTeW1hbnRlYyBTSEEyNTYgVGltZVN0YW1waW5nIFNp
// SIG // Z25lciAtIEcyoIIKizCCBTgwggQgoAMCAQICEHsFsdRJ
// SIG // aFFE98mJ0pwZnRIwDQYJKoZIhvcNAQELBQAwgb0xCzAJ
// SIG // BgNVBAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwgSW5j
// SIG // LjEfMB0GA1UECxMWVmVyaVNpZ24gVHJ1c3QgTmV0d29y
// SIG // azE6MDgGA1UECxMxKGMpIDIwMDggVmVyaVNpZ24sIElu
// SIG // Yy4gLSBGb3IgYXV0aG9yaXplZCB1c2Ugb25seTE4MDYG
// SIG // A1UEAxMvVmVyaVNpZ24gVW5pdmVyc2FsIFJvb3QgQ2Vy
// SIG // dGlmaWNhdGlvbiBBdXRob3JpdHkwHhcNMTYwMTEyMDAw
// SIG // MDAwWhcNMzEwMTExMjM1OTU5WjB3MQswCQYDVQQGEwJV
// SIG // UzEdMBsGA1UEChMUU3ltYW50ZWMgQ29ycG9yYXRpb24x
// SIG // HzAdBgNVBAsTFlN5bWFudGVjIFRydXN0IE5ldHdvcmsx
// SIG // KDAmBgNVBAMTH1N5bWFudGVjIFNIQTI1NiBUaW1lU3Rh
// SIG // bXBpbmcgQ0EwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAw
// SIG // ggEKAoIBAQC7WZ1ZVU+djHJdGoGi61XzsAGtPHGsMo8F
// SIG // a4aaJwAyl2pNyWQUSym7wtkpuS7sY7Phzz8LVpD4Yht+
// SIG // 66YH4t5/Xm1AONSRBudBfHkcy8utG7/YlZHz8O5s+K2W
// SIG // OS5/wSe4eDnFhKXt7a+Hjs6Nx23q0pi1Oh8eOZ3D9Jqo
// SIG // 9IThxNF8ccYGKbQ/5IMNJsN7CD5N+Qq3M0n/yjvU9bKb
// SIG // S+GImRr1wOkzFNbfx4Dbke7+vJJXcnf0zajM/gn1kze+
// SIG // lYhqxdz0sUvUzugJkV+1hHk1inisGTKPI8EyQRtZDqk+
// SIG // scz51ivvt9jk1R1tETqS9pPJnONI7rtTDtQ2l4Z4xaE3
// SIG // AgMBAAGjggF3MIIBczAOBgNVHQ8BAf8EBAMCAQYwEgYD
// SIG // VR0TAQH/BAgwBgEB/wIBADBmBgNVHSAEXzBdMFsGC2CG
// SIG // SAGG+EUBBxcDMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8v
// SIG // ZC5zeW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkaF2h0
// SIG // dHBzOi8vZC5zeW1jYi5jb20vcnBhMC4GCCsGAQUFBwEB
// SIG // BCIwIDAeBggrBgEFBQcwAYYSaHR0cDovL3Muc3ltY2Qu
// SIG // Y29tMDYGA1UdHwQvMC0wK6ApoCeGJWh0dHA6Ly9zLnN5
// SIG // bWNiLmNvbS91bml2ZXJzYWwtcm9vdC5jcmwwEwYDVR0l
// SIG // BAwwCgYIKwYBBQUHAwgwKAYDVR0RBCEwH6QdMBsxGTAX
// SIG // BgNVBAMTEFRpbWVTdGFtcC0yMDQ4LTMwHQYDVR0OBBYE
// SIG // FK9j1sqjToVy4Ke8QfMpojh/gHViMB8GA1UdIwQYMBaA
// SIG // FLZ3+mlIR59TEtXC6gcydgfRlwcZMA0GCSqGSIb3DQEB
// SIG // CwUAA4IBAQB16rAt1TQZXDJF/g7h1E+meMFv1+rd3E/z
// SIG // ociBiPenjxXmQCmt5l30otlWZIRxMCrdHmEXZiBWBpgZ
// SIG // jV1x8viXvAn9HJFHyeLojQP7zJAv1gpsTjPs1rSTyEyQ
// SIG // Y0g5QCHE3dZuiZg8tZiX6KkGtwnJj1NXQZAv4R5NTtzK
// SIG // EHhsQm7wtsX4YVxS9U72a433Snq+8839A9fZ9gOoD+NT
// SIG // 9wp17MZ1LqpmhQSZt/gGV+HGDvbor9rsmxgfqrnjOgC/
// SIG // zoqUywHbnsc4uw9Sq9HjlANgCk2g/idtFDL8P5dA4b+Z
// SIG // idvkORS92uTTw+orWrOVWFUEfcea7CMDjYUq0v+uqWGB
// SIG // MIIFSzCCBDOgAwIBAgIQVFjyqtdB1kS8hKl7oJZS5jAN
// SIG // BgkqhkiG9w0BAQsFADB3MQswCQYDVQQGEwJVUzEdMBsG
// SIG // A1UEChMUU3ltYW50ZWMgQ29ycG9yYXRpb24xHzAdBgNV
// SIG // BAsTFlN5bWFudGVjIFRydXN0IE5ldHdvcmsxKDAmBgNV
// SIG // BAMTH1N5bWFudGVjIFNIQTI1NiBUaW1lU3RhbXBpbmcg
// SIG // Q0EwHhcNMTcwMTAyMDAwMDAwWhcNMjgwNDAxMjM1OTU5
// SIG // WjCBgDELMAkGA1UEBhMCVVMxHTAbBgNVBAoTFFN5bWFu
// SIG // dGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRl
// SIG // YyBUcnVzdCBOZXR3b3JrMTEwLwYDVQQDEyhTeW1hbnRl
// SIG // YyBTSEEyNTYgVGltZVN0YW1waW5nIFNpZ25lciAtIEcy
// SIG // MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA
// SIG // mfP82AQJA4b511ymk8BCfOp8Y89dAOKO88CQ348p9Rjq
// SIG // lLeS5dewoHOB6OkKm0p8Af+dj6Q5pw7qRfQiDDpw7TlF
// SIG // i+TFG1zwRWhGJAVjdpsc/J5sKrFW5Yp/UnGu8jXVRiMG
// SIG // HM9ILR20zbjZdiOOHP8+v7sGXGkHpmUO+F6ufS7tTa41
// SIG // 78nXAEL9KJUOn11yQgm8w9pE0u3MR4Tk/MotrFi+rveu
// SIG // 2UQNCLfCd9YaQ3DRbgPeUpLEEAhx2boiVfIfvO2bnTvi
// SIG // Xh1Mg/+XD3sL51WDTtIN677X7K5uR7mf36XWUbwEVe3/
// SIG // J3BMye0qSxPhsblMD8kB7lVlX2kCeGbLPwIDAQABo4IB
// SIG // xzCCAcMwDAYDVR0TAQH/BAIwADBmBgNVHSAEXzBdMFsG
// SIG // C2CGSAGG+EUBBxcDMEwwIwYIKwYBBQUHAgEWF2h0dHBz
// SIG // Oi8vZC5zeW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBka
// SIG // F2h0dHBzOi8vZC5zeW1jYi5jb20vcnBhMEAGA1UdHwQ5
// SIG // MDcwNaAzoDGGL2h0dHA6Ly90cy1jcmwud3Muc3ltYW50
// SIG // ZWMuY29tL3NoYTI1Ni10c3MtY2EuY3JsMBYGA1UdJQEB
// SIG // /wQMMAoGCCsGAQUFBwMIMA4GA1UdDwEB/wQEAwIHgDB3
// SIG // BggrBgEFBQcBAQRrMGkwKgYIKwYBBQUHMAGGHmh0dHA6
// SIG // Ly90cy1vY3NwLndzLnN5bWFudGVjLmNvbTA7BggrBgEF
// SIG // BQcwAoYvaHR0cDovL3RzLWFpYS53cy5zeW1hbnRlYy5j
// SIG // b20vc2hhMjU2LXRzcy1jYS5jZXIwKAYDVR0RBCEwH6Qd
// SIG // MBsxGTAXBgNVBAMTEFRpbWVTdGFtcC0yMDQ4LTUwHQYD
// SIG // VR0OBBYEFAm1wf6WcpcpQ5rJ4AK6rvj9L7r2MB8GA1Ud
// SIG // IwQYMBaAFK9j1sqjToVy4Ke8QfMpojh/gHViMA0GCSqG
// SIG // SIb3DQEBCwUAA4IBAQAXswqI6VxaXiBrOwoVsmzFqYoy
// SIG // h9Ox9BxTroW+P5v/17y3lIW0x1J+lOi97WGy1KeZ5MPJ
// SIG // k8E1PQvoaApdVpi9sSI70UR617/wbVEyitUj3zgBN/bi
// SIG // Uyt6KxGPt01sejMDG3xrCZQXu+TbWNQhE2Xn7NElyix1
// SIG // mpx//Mm7KmirxH20z6PJbKfZxACciQp3kfRNovsxO4Zu
// SIG // 9uYfUAOGm7/LQqvmdptyWhEBisbvpW+V592uuuYiZfAY
// SIG // WRsRyc2At9iXRx9CCPiscR+wRlOz1LLVo6tQdUgSF4Kt
// SIG // z+BBTzJ+zZUcv5GKCD2kp2cClt8kTKXQQcCCYKOKFzJL
// SIG // 07zPpLSMMYICWjCCAlYCAQEwgYswdzELMAkGA1UEBhMC
// SIG // VVMxHTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9u
// SIG // MR8wHQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3Jr
// SIG // MSgwJgYDVQQDEx9TeW1hbnRlYyBTSEEyNTYgVGltZVN0
// SIG // YW1waW5nIENBAhBUWPKq10HWRLyEqXugllLmMAsGCWCG
// SIG // SAFlAwQCAaCBpDAaBgkqhkiG9w0BCQMxDQYLKoZIhvcN
// SIG // AQkQAQQwHAYJKoZIhvcNAQkFMQ8XDTE4MDExNjAzMDQw
// SIG // OVowLwYJKoZIhvcNAQkEMSIEII3QU4jfkiMSbbvntBo/
// SIG // AlUluGKuZ8qppYtQMm2E4CINMDcGCyqGSIb3DQEJEAIv
// SIG // MSgwJjAkMCIEIM96wXrQR+zV/cNoIgMbEtTvB4tvK0xe
// SIG // a6Qfj/LPS61nMAsGCSqGSIb3DQEBAQSCAQB+MjumVYEC
// SIG // fY5fPHFhvKzsECF5kn5bXL7PLCm9/onlweEf/NJKV+vq
// SIG // lClcBkEfQw39wjjtMSBrMtL4FD4KNuuAouJtGG+cjnox
// SIG // +6VHE16Ojb6AU84hk1MGYeUdFENhhKoQyghC0T4gn9wR
// SIG // OAOnp4Z6X68hF2of8P9iEeP92TK1DQLGjNoTdcViZRoh
// SIG // UBrt7C8P97iCQJGNIkPKuC8LlBgfnJvaO0JtD56qo6TT
// SIG // qZgh/Wkx+xsjL8FvK5ciYfkQbMpkuI0/CPEA4DoHDanh
// SIG // uD2C3ss7EaBTHLAxAayGQoTQ9JpuECMsMIOS74qIDXrX
// SIG // 6oZBBcEEPVpTvIyhupte7MI1
// SIG // End signature block
